% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriangulationPlotFunctions.R
\name{plotColorNodes}
\alias{plotColorNodes}
\title{plotColorNodes}
\usage{
plotColorNodes(letterList, whichWord, dims, wordInfo)
}
\arguments{
\item{letterList}{Letter list from processHandwriting function}

\item{whichWord}{Single word value denoting which line to plot - checked if too big inside function.}

\item{dims}{Dimensions of the original document}

\item{wordInfo}{Word information list}
}
\value{
Plot of single word.
}
\description{
This function returns a plot of a single Word extracted from a document.
It plots the color as well.
}
\examples{
twoSent_document = list()
twoSent_document$image = twoSent
twoSent_document$thin = thinImage(twoSent_document$image)
twoSent_processList = processHandwriting(twoSent_document$thin, dim(twoSent_document$image))

dims = dim(twoSent_document$image)
words = create_words(twoSent_processList) 
words_after_processing = process_words(words, dim(twoSent_document$image), TRUE)
plotColorNodes(twoSent_processList$letterList, 3, dims, words_after_processing)

}
