% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_cluster_template}
\alias{example_cluster_template}
\title{Example cluster template}
\format{
A list containing a single cluster template created by
\code{\link[=make_clustering_template]{make_clustering_template()}}. The cluster template was created by sorting
a random sample of 1000 graphs from 10 training documents into 10 clusters
with a K-means algorithm. The cluster template is a named list with 16
items:
\describe{
\item{centers_seed}{An integer for the random number generator.}
\item{cluster}{A vector of cluster assignments
for each graph used to create the cluster template.}
\item{centers}{The final cluster centers produced by the K-Means algorithm.}
\item{K}{The number of clusters to build (10) with the K-means algorithm.}
\item{n}{The number of training graphs to use (1000) in the K-means
algorithm.}
\item{docnames}{A vector that lists the training document from which each graph originated.}
\item{writers}{A vector that lists the writer of each graph.}
\item{iters}{The maximum number of iterations for the K-means
algorithm (3).}
\item{changes}{A vector of the number of graphs that
changed clusters on each iteration of the K-means algorithm.}
\item{outlierCutoff}{A vector of the outlier cutoff values calculated on
each iteration of the K-means algorithm.}
\item{stop_reason}{The reason the
K-means algorithm terminated.}
\item{wcd}{A matrix of the within cluster
distances on each iteration of the K-means algorithm. More specifically,
the distance between each graph and the center of the cluster to which it
was assigned  on each iteration.}
\item{wcss}{A vector of the
within-cluster sum of squares on each iteration of the K-means algorithm.}}
}
\usage{
example_cluster_template
}
\description{
An example cluster template created with \code{\link[=make_clustering_template]{make_clustering_template()}}. The
cluster template was created from handwriting samples
"w0016_s01_pLND_r01.png", "w0080_s01_pLND_r01.png", "w0124_s01_pLND_r01.png",
"w0138_s01_pLND_r01.png", and "w0299_s01_pLND_r01.png" from the CSAFE Handwriting
Database. The template has K=5 clusters.
}
\examples{
# view cluster fill counts for template training documents
template_data <- format_template_data(example_cluster_template)
plot_cluster_fill_counts(template_data, facet = TRUE)

}
\keyword{datasets}
