% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_fft.R
\name{hanr_fft}
\alias{hanr_fft}
\title{Anomaly detector using FFT}
\usage{
hanr_fft()
}
\value{
\code{hanr_fft} object
}
\description{
Anomaly detection using FFT
The FFT model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the FFT model presented in the stats library.
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 1
dataset <- har_examples$example1
head(dataset)

# setting up time series fft detector
model <- hanr_fft()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
