% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blueprint.R
\name{update_blueprint}
\alias{update_blueprint}
\title{Update a preprocessing blueprint}
\usage{
update_blueprint(blueprint, ...)
}
\arguments{
\item{blueprint}{A preprocessing blueprint.}

\item{...}{Name-value pairs of \emph{existing} elements in \code{blueprint} that should
be updated.}
}
\description{
\code{update_blueprint()} is the correct way to alter elements of an existing
\code{blueprint} object. It has two benefits over just doing
\code{blueprint$elem <- new_elem}.
\itemize{
\item The name you are updating \emph{must} already exist in the blueprint. This prevents
you from accidentally updating non-existent elements.
\item The constructor for the blueprint is automatically run after the update by
\code{refresh_blueprint()} to ensure that the blueprint is still valid.
}
}
\examples{

blueprint <- default_xy_blueprint()

# `intercept` defaults to FALSE
blueprint

update_blueprint(blueprint, intercept = TRUE)

# Can't update non-existent elements
try(update_blueprint(blueprint, intercpt = TRUE))

# Can't add non-valid elements
try(update_blueprint(blueprint, intercept = 1))

}
