% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-offset.R
\name{model_offset}
\alias{model_offset}
\title{Extract a model offset}
\usage{
model_offset(terms, data)
}
\arguments{
\item{terms}{A \code{"terms"} object corresponding to \code{data}, returned from a
call to \code{model_frame()}.}

\item{data}{A data frame returned from a call to \code{model_frame()}.}
}
\value{
A numeric vector representing the offset.
}
\description{
\code{model_offset()} extracts a numeric offset from a model frame. It is
inspired by \code{\link[stats:model.extract]{stats::model.offset()}}, but has nicer error messages and
is slightly stricter.
}
\details{
If a column that has been tagged as an offset is not numeric, a nice error
message is thrown telling you exactly which column was problematic.

\code{\link[stats:model.extract]{stats::model.offset()}} also allows for a column named \code{"(offset)"} to be
considered an offset along with any others that have been tagged by
\code{\link[stats:offset]{stats::offset()}}. However, \code{\link[stats:model.matrix]{stats::model.matrix()}} does not recognize
these columns as offsets (so it doesn't remove them as it should). Because
of this inconsistency, columns named \code{"(offset)"} are \emph{not} treated specially
by \code{model_offset()}.
}
\examples{

x <- model.frame(Species ~ offset(Sepal.Width), iris)

model_offset(terms(x), x)

xx <- model.frame(Species ~ offset(Sepal.Width) + offset(Sepal.Length), iris)

model_offset(terms(xx), xx)

# Problematic columns are caught with intuitive errors
tryCatch(
  expr = {
    x <- model.frame(~ offset(Species), iris)
    model_offset(terms(x), x)
  },
  error = function(e) {
    print(e$message)
  }
)

}
