% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHCE.R
\name{simHCE}
\alias{simHCE}
\title{Simulate an HCE with given event rates of time-to-event outcomes, mean and SD of the continuous outcome by treatment group}
\usage{
simHCE(
  n,
  TTE_A,
  TTE_P,
  CM_A,
  CM_P,
  CSD_A = 1,
  CSD_P = 1,
  fixedfy = 1,
  yeardays = 360,
  pat = 100,
  ord = 10000,
  seed = NULL
)
}
\arguments{
\item{n}{sample size per treatment group}

\item{TTE_A}{event rates in the active group for the time-to-event outcomes.}

\item{TTE_P}{event rates in the placebo group for the time-to-event outcomes. Should have the same length as TTE_A.}

\item{CM_A}{mean value for the continuous outcome of the active group.}

\item{CM_P}{mean value for the continuous outcome of the placebo group.}

\item{CSD_A}{standard deviation for the continuous outcome of the active group.}

\item{CSD_P}{standard deviation for the continuous outcome of the placebo group.}

\item{fixedfy}{length of follow-up in years.}

\item{yeardays}{number of days in a year.}

\item{pat}{scale of provided event rates (per pat-years).}

\item{ord}{the coefficient for creating ordinal values}

\item{seed}{the seed for generating random numbers.}
}
\value{
an object of class hce.
}
\description{
Simulate an HCE with given event rates of time-to-event outcomes, mean and SD of the continuous outcome by treatment group
}
\examples{
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
dat0 <- simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3)
str(dat0)
}
\seealso{
\code{\link[=hce]{hce()}}, \code{\link[=new_hce]{new_hce()}}, \code{\link[=validate_hce]{validate_hce()}}  for the helper, constructor, and validtaor functions of hce.
}
