% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{COVID19b}
\alias{COVID19b}
\title{COVID-19 ordinal scale dataset (preliminary report).}
\format{
a data frame with 844 rows and 2 variables:
\describe{
\item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
\item{TRTP}{treatment values, A Active or P Placebo, character}
}
}
\source{
\url{doi:10.1056/NEJMoa2007764}
}
\usage{
COVID19b
}
\description{
A dataset containing dataset with COVID-19 ordinal scale outcomes for 844 patients.
}
\examples{
#Frequencies
table(COVID19b)
mosaicplot(table(COVID19b), col = c(1, 8, 6, 2, 4, 5, 3, 7), 
xlab = "Treatment", ylab = "Ordinal Scale", main = "COVID-19 ordinal scale")
# Calculate win statistics
calcWINS(x = COVID19b, AVAL = "GROUP", TRTP = "TRTP", ref = "P")
}
\keyword{datasets}
