% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cure_estimate.R
\name{cure_estimate}
\alias{cure_estimate}
\title{Estimate cured fraction}
\usage{
cure_estimate(object)
}
\arguments{
\item{object}{a \code{survfit} object.}
}
\value{
estimated proportion of cured observations
}
\description{
Estimates the cured fraction using a Kaplan-Meier fitted object.
}
\examples{
library(survival)
set.seed(1234)
temp <- generate_cure_data(N = 100, J = 10, nTrue = 10, A = 1.8)
training <- temp$Training
km.fit <- survfit(Surv(Time, Censor) ~ 1, data = training)
cure_estimate(km.fit)
}
\seealso{
\code{\link{survfit}}, \code{\link{sufficient_fu_test}}, \code{\link{nonzerocure_test}}
}
\keyword{univar}
