// (c) The HDF Group
#ifndef H5public_H
#define H5public_H
#include "H5pubconf.h"
#include "H5version.h"
#ifdef H5_HAVE_FEATURES_H
#include <features.h>
#endif
#ifdef __cplusplus
#include <cinttypes>
#else
#include <inttypes.h>
#endif
#include <limits.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#ifdef H5_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef H5_HAVE_PARALLEL
#ifndef MPICH_SKIP_MPICXX
#define MPICH_SKIP_MPICXX 1
#endif
#ifndef OMPI_SKIP_MPICXX
#define OMPI_SKIP_MPICXX 1
#endif
#include <mpi.h>
#ifndef MPI_FILE_NULL
#include <mpio.h>
#endif
#endif
#define H5_NO_EXPAND(x) (x)
#define H5_VERS_MAJOR 1
#define H5_VERS_MINOR 14
#define H5_VERS_RELEASE 6
#define H5_VERS_SUBRELEASE ""
#define H5_VERS_STR "1.14.6"
#define H5_VERS_INFO "HDF5 library version: 1.14.6"
#define H5check() H5check_version(H5_VERS_MAJOR, H5_VERS_MINOR, H5_VERS_RELEASE)
#define H5_VERSION_GE(Maj, Min, Rel)                                                                         \
    (((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR == Min) && (H5_VERS_RELEASE >= Rel)) ||                       \
     ((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR > Min)) || (H5_VERS_MAJOR > Maj))
#define H5_VERSION_LE(Maj, Min, Rel)                                                                         \
    (((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR == Min) && (H5_VERS_RELEASE <= Rel)) ||                       \
     ((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR < Min)) || (H5_VERS_MAJOR < Maj))
#define HDF5_DRIVER "HDF5_DRIVER"
#define HDF5_DRIVER_CONFIG "HDF5_DRIVER_CONFIG"
#define HDF5_VOL_CONNECTOR "HDF5_VOL_CONNECTOR"
#define HDF5_PLUGIN_PATH "HDF5_PLUGIN_PATH"
#define HDF5_PLUGIN_PRELOAD "HDF5_PLUGIN_PRELOAD"
#define HDF5_USE_FILE_LOCKING "HDF5_USE_FILE_LOCKING"
#define HDF5_NOCLEANUP "HDF5_NOCLEANUP"
typedef int herr_t;
#include <stdbool.h>
typedef bool hbool_t;
typedef int htri_t;
#if H5_SIZEOF_SSIZE_T == 0
#undef H5_SIZEOF_SSIZE_T
#if H5_SIZEOF_SIZE_T == H5_SIZEOF_INT
typedef int ssize_t;
#define H5_SIZEOF_SSIZE_T H5_SIZEOF_INT
#elif H5_SIZEOF_SIZE_T == H5_SIZEOF_LONG
typedef long ssize_t;
#define H5_SIZEOF_SSIZE_T H5_SIZEOF_LONG
#elif H5_SIZEOF_SIZE_T == H5_SIZEOF_LONG_LONG
typedef long long ssize_t;
#define H5_SIZEOF_SSIZE_T H5_SIZEOF_LONG_LONG
#else
#error "nothing appropriate for ssize_t"
#endif
#endif
typedef uint64_t hsize_t;
#ifdef H5_HAVE_PARALLEL
#define HSIZE_AS_MPI_TYPE MPI_UINT64_T
#endif
typedef int64_t hssize_t;
#define PRIdHSIZE PRId64
#define PRIiHSIZE PRIi64
#define PRIoHSIZE PRIo64
#define PRIuHSIZE PRIu64
#define PRIxHSIZE PRIx64
#define PRIXHSIZE          PRIX64
#define H5_SIZEOF_HSIZE_T  8
#define H5_SIZEOF_HSSIZE_T 8
#define HSIZE_UNDEF UINT64_MAX
typedef uint64_t haddr_t;
#define PRIdHADDR PRId64
#define PRIoHADDR PRIo64
#define PRIuHADDR PRIu64
#define PRIxHADDR PRIx64
#define PRIXHADDR           PRIX64
#define H5_SIZEOF_HADDR_T   8
#define HADDR_UNDEF         UINT64_MAX
#define H5_PRINTF_HADDR_FMT "%" PRIuHADDR
#define HADDR_MAX           (HADDR_UNDEF - 1)
#ifdef H5_HAVE_PARALLEL
#define HADDR_AS_MPI_TYPE MPI_UINT64_T
#endif
//! <!-- [H5_iter_order_t_snip] -->
typedef enum {
    H5_ITER_UNKNOWN = -1,
    H5_ITER_INC,
    H5_ITER_DEC,
    H5_ITER_NATIVE,
    H5_ITER_N
} H5_iter_order_t;
//! <!-- [H5_iter_order_t_snip] -->
#define H5_ITER_ERROR (-1)
#define H5_ITER_CONT  (0)
#define H5_ITER_STOP  (1)
//! <!-- [H5_index_t_snip] -->
typedef enum H5_index_t {
    H5_INDEX_UNKNOWN = -1,
    H5_INDEX_NAME,
    H5_INDEX_CRT_ORDER,
    H5_INDEX_N
} H5_index_t;
//! <!-- [H5_index_t_snip] -->
//! <!-- [H5_ih_info_t_snip] -->
typedef struct H5_ih_info_t {
    hsize_t index_size;
    hsize_t heap_size;
} H5_ih_info_t;
//! <!-- [H5_ih_info_t_snip] -->
#define H5O_MAX_TOKEN_SIZE (16)
//! <!-- [H5O_token_t_snip] -->
typedef struct H5O_token_t {
    uint8_t __data[H5O_MAX_TOKEN_SIZE];
} H5O_token_t;
//! <!-- [H5O_token_t_snip] -->
typedef void (*H5_atclose_func_t)(void *ctx);
#include "H5api_adpt.h"
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5open(void);
H5_DLL herr_t H5atclose(H5_atclose_func_t func, void *ctx);
H5_DLL herr_t H5close(void);
H5_DLL herr_t H5dont_atexit(void);
H5_DLL herr_t H5garbage_collect(void);
H5_DLL herr_t H5set_free_list_limits(int reg_global_lim, int reg_list_lim, int arr_global_lim,
                                     int arr_list_lim, int blk_global_lim, int blk_list_lim);
H5_DLL herr_t H5get_free_list_sizes(size_t *reg_size, size_t *arr_size, size_t *blk_size, size_t *fac_size);
H5_DLL herr_t H5get_libversion(unsigned *majnum, unsigned *minnum, unsigned *relnum);
H5_DLL herr_t H5check_version(unsigned majnum, unsigned minnum, unsigned relnum);
H5_DLL herr_t H5is_library_terminating(hbool_t *is_terminating);
H5_DLL herr_t H5is_library_threadsafe(hbool_t *is_ts);
H5_DLL herr_t H5free_memory(void *mem);
H5_DLL void *H5allocate_memory(size_t size, hbool_t clear);
H5_DLL void *H5resize_memory(void *mem, size_t size);
#ifdef __cplusplus
}
#endif
#endif
