% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_3_compare_by_calibrate.R
\name{compare_by_calibrate}
\alias{compare_by_calibrate}
\title{Compare high-dimensional Cox models by model calibration}
\usage{
compare_by_calibrate(
  x,
  time,
  event,
  model.type = c("lasso", "alasso", "flasso", "enet", "aenet", "mcp", "mnet", "scad",
    "snet"),
  method = c("fitting", "bootstrap", "cv", "repeated.cv"),
  boot.times = NULL,
  nfolds = NULL,
  rep.times = NULL,
  pred.at,
  ngroup = 5,
  seed = 1001,
  trace = TRUE
)
}
\arguments{
\item{x}{Matrix of training data used for fitting the model;
on which to run the calibration.}

\item{time}{Survival time.
Must be of the same length with the number of rows as \code{x}.}

\item{event}{Status indicator, normally 0 = alive, 1 = dead.
Must be of the same length with the number of rows as \code{x}.}

\item{model.type}{Model types to compare. Could be at least two of
\code{"lasso"}, \code{"alasso"}, \code{"flasso"}, \code{"enet"},
\code{"aenet"}, \code{"mcp"}, \code{"mnet"}, \code{"scad"},
or \code{"snet"}.}

\item{method}{Calibration method.
Could be \code{"bootstrap"}, \code{"cv"}, or \code{"repeated.cv"}.}

\item{boot.times}{Number of repetitions for bootstrap.}

\item{nfolds}{Number of folds for cross-validation and
repeated cross-validation.}

\item{rep.times}{Number of repeated times for repeated cross-validation.}

\item{pred.at}{Time point at which calibration should take place.}

\item{ngroup}{Number of groups to be formed for calibration.}

\item{seed}{A random seed for cross-validation fold division.}

\item{trace}{Logical. Output the calibration progress or not.
Default is \code{TRUE}.}
}
\description{
Compare high-dimensional Cox models by model calibration
}
\examples{
data(smart)
x <- as.matrix(smart[, -c(1, 2)])
time <- smart$TEVENT
event <- smart$EVENT

# Compare lasso and adaptive lasso by 5-fold cross-validation
cmp.cal.cv <- compare_by_calibrate(
  x, time, event,
  model.type = c("lasso", "alasso"),
  method = "fitting",
  pred.at = 365 * 9, ngroup = 5, seed = 1001
)

print(cmp.cal.cv)
summary(cmp.cal.cv)
plot(cmp.cal.cv)
}
