% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.nc.hdqr-methods.R
\name{predict.cv.nc.hdqr}
\alias{predict.cv.nc.hdqr}
\title{Make Predictions from a `cv.nc.hdqr` Object}
\usage{
\method{predict}{cv.nc.hdqr}(object, newx, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A fitted `cv.nc.hdqr()` object from which predictions are to be made.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Specifies the value(s) of the penalty parameter `lambda` at which predictions
are desired. The default is `s = "lambda.1se"`, representing the largest value of `lambda`
such that the cross-validation error estimate is within one standard error of the minimum.
Alternatively, `s = "lambda.min"` can be used, corresponding to the minimum of the
cross-validation error estimate. If `s` is numeric, these are taken as the actual values
of `lambda` to use for predictions.}

\item{...}{Not used.}
}
\value{
Returns a matrix or vector of predicted values corresponding to the specified
  `lambda` values.
}
\description{
Generates predictions using a fitted `cv.nc.hdqr()` object. This function utilizes the
stored `nchdqr.fit` object and an optimal value of `lambda` determined during the
cross-validation process.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x <- matrix(data = rnorm(n * p, mean = 0, sd = 1), nrow = n, ncol = p)
beta_star <- c(c(2, 1.5, 0.8, 1, 1.75, 0.75, 0.3), rep(0, (p - 7)))
eps <- rnorm(n, mean = 0, sd = 1)
y <- x \%*\% beta_star + eps
tau <- 0.5
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out=10))
\donttest{cv.nc.fit <- cv.nc.hdqr(x = x, y = y, tau = tau, lambda = lambda, lam2 = lam2)}
\donttest{predict(cv.nc.fit, newx = x[50:60, ], s = "lambda.min")}
}
\seealso{
\code{\link{cv.nc.hdqr}}, \code{\link{predict.cv.nc.hdqr}}
}
