% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrcv.R
\name{cv.hdqr}
\alias{cv.hdqr}
\title{Cross-validation for Selecting the Tuning Parameter in Penalized Quantile Regression}
\usage{
cv.hdqr(x, y, lambda = NULL, tau, nfolds = 5L, foldid, ...)
}
\arguments{
\item{x}{A numerical matrix with \eqn{n} rows (observations) and \eqn{p} columns (variables).}

\item{y}{Response variable.}

\item{lambda}{Optional; a user-supplied sequence of \code{lambda} values. If \code{NULL}, 
\code{\link{hdqr}} selects its own sequence.}

\item{tau}{Quantile level (\code{tau}) used in the loss function.}

\item{nfolds}{Number of folds for cross-validation. Defaults to 5.}

\item{foldid}{Optional vector specifying the indices of observations in each fold.
If provided, it overrides \code{nfolds}.}

\item{...}{Additional arguments passed to \code{\link{hdqr}}.}
}
\value{
An object with S3 class \code{cv.hdqr} consisting of
  \item{lambda}{Candidate \code{lambda} values.}
  \item{cvm}{Mean cross-validation error.}
  \item{cvsd}{Standard error of the mean cross-validation error.}
  \item{cvup}{Upper confidence curve: \code{cvm} + \code{cvsd}.}
  \item{cvlo}{Lower confidence curve: \code{cvm} - \code{cvsd}.}
  \item{lambda.min}{\code{lambda} achieving the minimum cross-validation error.}
  \item{lambda.1se}{Largest \code{lambda} within one standard error of the minimum error.}
  \item{cv.min}{Cross-validation error at \code{lambda.min}.}
  \item{cv.1se}{Cross-validation error at \code{lambda.1se}.}
  \item{hdqr.fit}{a fitted \code{\link{hdqr}} object for the full data.}
  \item{nzero}{Number of non-zero coefficients at each \code{lambda}.}
}
\description{
Performs k-fold cross-validation for \code{\link{hdqr}}.
}
\details{
This function computes the average cross-validation error and provides the standard error.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x <- matrix(data = rnorm(n * p, mean = 0, sd = 1), nrow = n, ncol = p)
beta_star <- c(c(2, 1.5, 0.8, 1, 1.75, 0.75, 0.3), rep(0, (p - 7)))
eps <- rnorm(n, mean = 0, sd = 1)
y <- x \%*\% beta_star + eps
tau <- 0.5
cv.fit <- cv.hdqr(x = x, y = y, tau = tau)
}
\keyword{models}
\keyword{regression}
