\name{hdrbw}
\alias{hdrbw}
\title{Highest Density Region Bandwidth}

\description{Calculates optimal bandwidth for 1-dimensional highest density regions}

\usage{
hdrbw(x, HDRlevel, gridsize = 801, nMChdr = 1e+06, graphProgress = FALSE) 
}
\arguments{
  \item{x}{Numerical vector containing data.}
  \item{HDRlevel}{HDR-level as defined in Hyndman (1996). Setting
    `HDRlevel' equal to p (0<p<1) corresponds to a
     probability of 1-p of inclusion in
     the highest density region.}
  \item{gridsize}{the number of equally spaced points used for binned
    kernel density estimation.}
  \item{nMChdr}{the size of the Monte Carlo sample used for density
    quantile approximation of the highest density region, as described
    in Hyndman (1996).}
\item{graphProgress}{logical flag: if `TRUE' then plots showing the
progress of the bandwidth selection algorithm are produced.}
}
\value{A numerical vector of length 1.}

\details{This is a plug-in rule for bandwidth selection tailored to
  highest density region estimation }

\references{
  Hyndman, R.J. (1996). Computing and graphing highest density regions. 
  \emph{The American Statistician}, \bold{50}, 120-126.
  
  Samworth, R.J., and Wand, M.P. (2009).  Asymptotics and optimal 
  bandwidth selection for highest density region estimation.  
  Working paper. \url{http://www.uow.edu.au/~mwand/hdrpap.pdf}.
}

\author{Matt Wand}

\examples{
HDRlevelVal <- 0.55
x <- faithful$eruptions
hHDR <- hdrbw(x,HDRlevelVal)
HDRhat <- hdr.den(x,prob=100*(1-HDRlevelVal),h=hHDR)
}
\keyword{smooth}
\keyword{distribution}

