% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-headline-column.R
\name{add_headline_column}
\alias{add_headline_column}
\title{Add column of headlines}
\usage{
add_headline_column(
  df,
  x,
  y,
  headline = "{trend} of {delta} ({orig_values})",
  ...,
  .name = "headline",
  if_match = "There was no difference.",
  trend_phrases = headliner::trend_terms(),
  plural_phrases = NULL,
  orig_values = "{x} vs. {y}",
  n_decimal = 1,
  round_all = TRUE,
  multiplier = 1,
  return_cols = .name
)
}
\arguments{
\item{df}{data frame, must be a single row}

\item{x}{a numeric value to compare to the reference value of 'y'}

\item{y}{a numeric value to act as a control for the 'x' value}

\item{headline}{a string to format the final output. Uses
\code{\link[glue]{glue}} syntax}

\item{...}{arguments passed to \code{\link[glue]{glue_data}}}

\item{.name}{string value for the name of the new column to create}

\item{if_match}{string to display if numbers match, uses
\code{\link[glue]{glue}} syntax}

\item{trend_phrases}{list of values to use for when y is more than x, y is the
same as x, or y is less than x. You can pass it just
\code{\link{trend_terms}} (the default) and call the result with
\code{"...{trend}..."} or pass is a named list (see examples)}

\item{plural_phrases}{named list of values to use when difference (delta) is
singular (delta = 1) or plural (delta != 1)}

\item{orig_values}{a string using \code{\link[glue]{glue}} syntax.
example: \verb{(\{x\} vs \{y\})}}

\item{n_decimal}{numeric value to limit the number of decimal places in
the returned values.}

\item{round_all}{logical value to indicate if all values should be rounded.
When FALSE, the values will return with no modification. When TRUE (default)
all values will be round to the length specified by 'n_decimal'.}

\item{multiplier}{number indicating the scaling factor. When multiplier = 1
(default), 0.25 will return 0.25. When multiplier = 100, 0.25 will return 25.}

\item{return_cols}{arguments that can be passed to
\code{\link[dplyr]{select}}, ex: c("a", "b"),
\code{\link[dplyr]{starts_with}}, etc.}
}
\value{
Returns the original data frame with columns appended.
}
\description{
This works similar to \code{headline()} but acts on and returns a
data frame.
}
\details{
What is nice about this function is you can return some of the
"talking points" used in the headline calculation. For example, if you want
to find the most extreme headlines, you can use
\code{add_headline_column(..., return_cols = delta)} This will bring back a
\code{headline} column as well as the \code{delta} talking point (the absolute
difference between \code{x} and \code{y}). With this result, you can sort in descending
order and filter for the biggest difference.
}
\examples{

# You can use 'add_headline_column()' to reference values in an existing data set.
# Here is an example comparing the box office sales of different Pixar films
head(pixar_films) |>
  dplyr::select(film, bo_domestic, bo_intl) |>
  add_headline_column(
    x = bo_domestic,
    y = bo_intl,
    headline = "{film} was ${delta}M higher {trend} (${x}M vs ${y}M)",
    trend_phrases = trend_terms(more = "domestically", less = "internationally")
  ) |>
  knitr::kable("pandoc")

# You can also use 'return_cols' to return any and all "talking points".
# You can use tidyselect helpers like 'starts_with("delta")' or
# 'everything()'. In this example, I returned the 'raw_delta' & 'trend' columns
# and then identified the records at the extremes
pixar_films |>
  dplyr::select(film, bo_domestic, bo_intl) |>
  add_headline_column(
    x = bo_domestic,
    y = bo_intl,
    headline = "${delta}M {trend} (${x}M vs ${y}M)",
    trend_phrases = trend_terms(more = "higher", less = "lower"),
    return_cols = c(raw_delta, trend)
  ) |>
  dplyr::filter(raw_delta \%in\% range(raw_delta)) |>
  knitr::kable("pandoc")

}
