% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-column-row-expectations.R
\name{isTargetYN}
\alias{isTargetYN}
\title{Tests whether predictedCol is Y/N. Allows for NAs to be present.}
\usage{
isTargetYN(x)
}
\arguments{
\item{x}{A data frame column, matrix column, or vector}
}
\value{
A boolean
}
\description{
Returns a logical, TRUE or FALSE, depending on what is
contained in the vector.  If any NAs are present in the vector, they will be
removed later on in development with removeRowsWithNAInSpecCol.
}
\examples{
dat <- data.frame(a = c(0,1,1,0,0,0,1,1,1,0,1,0,1,0,1,0,1,1,1,0))
dat2 <- data.frame(a = c(3, 4, 5, 6, 7, 8, 9))
dat3 <- data.frame(a = c('Y', 'N', 'Y', 'N'))
dat4 <- data.frame(a = c('Y', 'N', 'Y', 'N', NA))
isTargetYN(dat[, 1])
isTargetYN(dat2[, 1])
isTargetYN(dat3[, 1])
isTargetYN(dat4[, 1])

}
\references{
\url{http://healthcareai-r.readthedocs.io}
}
\seealso{
\code{\link{healthcareai}}
}
