% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_dummy_hcai.R
\name{step_dummy_hcai}
\alias{step_dummy_hcai}
\alias{tidy.step_dummy_hcai}
\title{Dummy Variables Creation}
\usage{
step_dummy_hcai(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  naming = dummy_names,
  levels = NULL,
  skip = FALSE,
  id = rand_id("bagimpute")
)

\method{tidy}{step_dummy_hcai}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be used to create the dummy variables. See
[selections()] for more details. The selected
variables must be factors. For the \code{tidy} method, these are
not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the binary dummy variable columns created by the original
variables will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{naming}{A function that defines the naming convention for
new dummy columns. See Details below.}

\item{levels}{A list that provides the ordered levels of nominal variables.
If all the unique values in a nominal variable are not included, the
remaining values will be added to the given levels. The first level will be
listed as the \code{ref_level} attribute for the step object. If levels are
not provided for a nominal variable, the mode value will be used as the
reference level.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A `step_dummy_hcai` object.}
}
\value{
An updated version of \code{recipe} with the new step
 added to the sequence of existing steps (if any). For the
 \code{tidy} method, a tibble with columns \code{terms} (the
 selectors or variables selected).
}
\description{
\code{step_dummy_hcai} creates a *specification* of a recipe step
 that will convert nominal data (e.g. character or factors) into one or more
 numeric binary model terms for the levels of the original data. Various
 portions of this step are copied from \code{recipes::step_dummy}. Beyond
 original \code{recipes::step_dummy} implementation, this step sets reference
 levels to provided reference levels or mode.
}
\details{
\code{step_dummy_hcai} will create a set of binary dummy
 variables from a factor variable. For example, if an unordered
 factor column in the data set has levels of "red", "green",
 "blue", the dummy variable bake will create two additional
 columns of 0/1 data for two of those three values (and remove
 the original column). For ordered factors, polynomial contrasts
 are used to encode the numeric values.

By default, the excluded dummy variable (i.e. the reference
 cell) will correspond to the first level of the unordered
 factor being converted.

The function allows for non-standard naming of the resulting
 variables. For an unordered factor named `x`, with levels `"a"`
 and `"b"`, the default naming convention would be to create a
 new variable called `x_b`. Note that if the factor levels are
 not valid variable names (e.g. "some text with spaces"), it will
 be changed by [base::make.names()] to be valid (see the example
 below). The naming format can be changed using the `naming`
 argument and the function [dummy_names()] is the default. This
 function will also change the names of ordinal dummy variables.
 Instead of values such as "`.L`", "`.Q`", or "`^4`", ordinal
 dummy variables are given simple integer suffixes such as
 "`_1`", "`_2`", etc.

To change the type of contrast being used, change the global
contrast option via `options`.

When the factor being converted has a missing value, all of the
 corresponding dummy variables are also missing.

When data to be processed contains novel levels (i.e., not
contained in the training set), a missing value is assigned to
the results. See [step_other()] for an alternative.

The [package vignette for dummy variables](
https://topepo.github.io/recipes/articles/Dummies.html)
and interactions has more information.
}
\examples{
rec <- recipes::recipe(head(pima_diabetes), ~.) \%>\%
  healthcareai:::step_dummy_hcai(weight_class)
d <- recipes::prep(rec, training = pima_diabetes)
d <- recipes::bake(d, new_data = pima_diabetes)

# Specify ref_levels
ref_levels <- list(weight_class = "normal")
rec <- recipes::recipe(head(pima_diabetes), ~.)
rec <- rec \%>\% healthcareai:::step_dummy_hcai(weight_class,
                                              levels = ref_levels)

}
\seealso{
[step_factor2string()], [step_string2factor()],
 [dummy_names()], [step_regex()], [step_count()],
 [step_ordinalscore()], [step_unorder()], [step_other()]
 [step_novel()]
}
\keyword{datagen}
