% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.R
\name{r}
\alias{r}
\title{Ratio (R)}
\usage{
r(
  est,
  se = NULL,
  favourable_indicator,
  ordered_dimension = NULL,
  subgroup_order = NULL,
  reference_subgroup = NULL,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{est}{The subgroup estimate.
Estimates must be available for all subgroups.}

\item{se}{The standard error of the subgroup estimate.
If this is missing, 95\% confidence intervals of MDBU cannot be calculated.}

\item{favourable_indicator}{Records whether the indicator is
favourable (1) or non-favourable (0). Favourable indicators measure
desirable health events where the ultimate goal is
to achieve a maximum level (such as skilled birth attendance).
Non-favourable indicators measure undesirable health events where
the ultimate goal is to achieve a minimum level (such as under-five
mortality rate).}

\item{ordered_dimension}{Records whether the dimension is ordered (1)
or not (0).}

\item{subgroup_order}{The order of subgroups in an increasing sequence.}

\item{reference_subgroup}{Identifies a reference subgroup with the value of
1.}

\item{conf.level}{confidence level of the interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated D value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The ratio (R) is a relative measure of inequality that shows the ratio
of a health indicator between two population subgroups. For more
information on this inequality measure see Schlotheuber, A., &
Hosseinpoor, A. R. (2022) below.
}
\details{
R is calculated as: \code{R = y_1/y_2} where \code{y_1} and \code{y_2} indicate the
estimates for subgroups 1 and 2. The selection of the two subgroups depends
on the characteristics of the inequality dimension and the purpose of the
analysis. In addition, the direction of the calculation may depend on the
indicator type (favourable or adverse). Below are some examples of how
y_1 and y_2 may be identified.

\strong{Interpretation:} The index R only assumes positive values. The further
the value of R from one, the higher the level of inequality. R is one if
there is no inequality.

\strong{Type of summary measure:} Simple; relative; unweighted.

\strong{Applicability:} Any

\strong{Warning:} The confidence intervals are approximate
and might be biased. See Ahn J. et al. (1978) below for
further information on the standard error formula.
}
\examples{
# example code
data(NonorderedSample)
head(NonorderedSample)
with(NonorderedSample,
     r(est = estimate,
       se = se,
       favourable_indicator,
       ordered_dimension = ordered_dimension,
       reference_subgroup = reference_subgroup
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.

Ahn J, Harper S, Yu M, Feuer EJ, Liu B, Luta G. Variance
Estimation and Confidence Intervals for 11 Commonly Used
Health Disparity Measures. JCO Clin Cancer Inform. 2018
Dec;2:1--19.
}
