% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate-knn.R
\name{hai_auto_knn}
\alias{hai_auto_knn}
\title{Boilerplate Workflow}
\usage{
hai_auto_knn(
  .data,
  .rec_obj,
  .splits_obj = NULL,
  .rsamp_obj = NULL,
  .tune = TRUE,
  .grid_size = 10,
  .num_cores = 1,
  .best_metric = "rmse",
  .model_type = "regression"
)
}
\arguments{
\item{.data}{The data being passed to the function. The time-series object.}

\item{.rec_obj}{This is the recipe object you want to use. You can use
\code{hai_knn_data_prepper()} and an automatic recipe_object.}

\item{.splits_obj}{NULL is the default, when NULL then one will be created.}

\item{.rsamp_obj}{NULL is the default, when NULL then one will be created. It
will default to creating an \code{\link[rsample:mc_cv]{rsample::mc_cv()}} object.}

\item{.tune}{Default is TRUE, this will create a tuning grid and tuned workflow}

\item{.grid_size}{Default is 10}

\item{.num_cores}{Default is 1}

\item{.best_metric}{Default is "rmse". You can choose a metric depending on the
model_type used. If \code{regression} then see \code{\link[=hai_default_regression_metric_set]{hai_default_regression_metric_set()}},
if \code{classification} then see \code{\link[=hai_default_classification_metric_set]{hai_default_classification_metric_set()}}.}

\item{.model_type}{Default is \code{regression}, can also be \code{classification}.}
}
\value{
A list
}
\description{
This is a boilerplate function to create automatically the following:
\itemize{
\item recipe
\item model specification
\item workflow
\item tuned model (grid ect)
}
}
\details{
This uses the \code{parsnip::nearest_neighbor()} with the \code{engine} set to \code{kknn}
}
\examples{
\dontrun{
library(dplyr)

data <- iris

rec_obj <- hai_knn_data_prepper(data, Species ~ .)

auto_knn <- hai_auto_knn(
  .data = data,
  .rec_obj = rec_obj,
  .best_metric = "f_meas",
  .model_type = "classification"
)

auto_knn$recipe_info
}

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Boiler_Plate}
\concept{k-NN}
