% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-info-tbl.R
\name{ts_info_tbl}
\alias{ts_info_tbl}
\title{Get Time Series Information}
\usage{
ts_info_tbl(.data, .date_col)
}
\arguments{
\item{.data}{The data you are passing to the function}

\item{.date_col}{This is only needed if you are passing a tibble.}
}
\value{
A tibble
}
\description{
This function will take in a data set and return to you a tibble of useful
information.
}
\details{
This function can accept objects of the following classes:
\itemize{
\item ts
\item xts
\item mts
\item zoo
\item tibble/data.frame
}

The function will return the following pieces of information in a tibble:
\itemize{
\item name
\item class
\item frequency
\item start
\item end
\item var
\item length
}
}
\examples{

library(healthyR.data)
library(dplyr)
library(timetk)
data_tbl <- healthyR_data\%>\%
    filter(ip_op_flag == 'I') \%>\%
    summarise_by_time(
        .date_var = visit_end_date_time,
        .by = "month",
        value = n()
    ) \%>\%
    filter_by_time(
        .date_var = visit_end_date_time,
        .start_date = "2015",
        .end_date = "2019"
    ) \%>\%
    rename(date_col = visit_end_date_time)

ts_info_tbl(AirPassengers)
ts_info_tbl(BJsales)
ts_info_tbl(data_tbl, date_col)

}
\seealso{
Other Utility: 
\code{\link{calibrate_and_plot}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
