% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{ts_random_walk_ggplot_layers}
\alias{ts_random_walk_ggplot_layers}
\title{Get Random Walk \code{ggplot2} layers}
\usage{
ts_random_walk_ggplot_layers(.data)
}
\arguments{
\item{.data}{The data passed to the function.}
}
\value{
A \code{ggplot2} layers object
}
\description{
Get layers to add to a \code{ggplot} graph from the \code{\link[=ts_random_walk]{ts_random_walk()}} function.
}
\details{
\itemize{
\item Set the intercept of the initial value from the random walk
\item Set the max and min of the cumulative sum of the random walks
}
}
\examples{
library(ggplot2)

df <- ts_random_walk()

df \%>\%
  ggplot(
    mapping = aes(
      x = x
      , y = cum_y
      , color = factor(run)
      , group = factor(run)
   )
 ) +
 geom_line(alpha = 0.8) +
 ts_random_walk_ggplot_layers(df)

}
\author{
Steven P. Sanderson II, MPH
}
