% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tbl_functions.R
\name{top_n_tbl}
\alias{top_n_tbl}
\title{Top N tibble}
\usage{
top_n_tbl(.data, .n_records, .arrange_value = TRUE, ...)
}
\arguments{
\item{.data}{The data you want to pass to the function}

\item{.n_records}{How many records you want returned}

\item{.arrange_value}{A boolean with TRUE as the default. TRUE sorts data in
descending order}

\item{...}{The columns you want to pass to the function.}
}
\description{
Get a tibble returned with n records sorted either by descending order (default) or
ascending order.
}
\details{
\itemize{
\item Requires a data.frame/tibble
\item Requires at least one column to be chosen inside of the ...
\item Will return the tibble in sorted order that is chosen with descending as
the default
}
}
\examples{
library(healthyR.data)

df <- healthyR_data

df_tbl <- top_n_tbl(
  .data = df
  , .n_records = 3
  , .arrange_value = TRUE
  , service_line
  , payer_grouping
)

print(df_tbl)

}
\author{
Steven P. Sanderson II, MPH
}
