% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_eval.R
\name{eval_surv}
\alias{eval_surv}
\alias{eval_surv}
\alias{compute_surv_}
\alias{eval_surv.survfit}
\alias{eval_surv.flexsurvreg}
\alias{eval_surv.surv_model}
\alias{eval_surv.surv_projection}
\alias{eval_surv.surv_pooled}
\alias{eval_surv.surv_ph}
\alias{eval_surv.surv_shift}
\alias{eval_surv.surv_aft}
\alias{eval_surv.surv_po}
\alias{eval_surv.surv_add_haz}
\alias{eval_surv.surv_dist}
\alias{eval_surv.surv_table}
\title{Evaluate Survival Distributions}
\usage{
eval_surv(x, time, ...)

compute_surv_(x, time, cycle_length = 1, type = c("prob", "survival"), ...)

\method{eval_surv}{survfit}(x, time, ...)

\method{eval_surv}{flexsurvreg}(x, time, ...)

\method{eval_surv}{surv_model}(x, time, ...)

\method{eval_surv}{surv_projection}(x, time, ...)

\method{eval_surv}{surv_pooled}(x, time, ...)

\method{eval_surv}{surv_ph}(x, time, ...)

\method{eval_surv}{surv_shift}(x, time, ...)

\method{eval_surv}{surv_aft}(x, time, ...)

\method{eval_surv}{surv_po}(x, time, ...)

\method{eval_surv}{surv_add_haz}(x, time, ...)

\method{eval_surv}{surv_dist}(x, time, ...)

\method{eval_surv}{surv_table}(x, time, ...)
}
\arguments{
\item{x}{A survival distribution object}

\item{time}{The \code{model_time} or \code{state_time} for which
to predict.}

\item{...}{arguments passed to methods.}

\item{cycle_length}{The value of a Markov cycle in
absolute time units.}

\item{type}{Either \code{prob}, for transition probabilities,
or \code{surv}, for survival.}
}
\value{
Returns either the survival probalities or
conditional probabilities of event for each cycle.
}
\description{
Generate either survival probabilities or conditional
probabilities of event for each model cycle.
}
\details{
The results of \code{compute_surv()} are memoised for
\code{options("heemod.memotime")} (default: 1 hour) to
increase resampling performance.
}
\keyword{internal}
