/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class StaticVis {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 600;
    private static final int MIN_RESIDUES = 2;
    private static final int MAX_RESIDUES_WHEEL = 18;
    private static final int MAX_RESIDUES_WENXIANG = 19;
    private static final int CENTER_X = 300;
    private static final int CENTER_Y = 325;
    private static final int RADIUS = 225;
    private static final int WHEEL_RESID_RADIUS = 37;
    private static final int WENXIANG_RESID_RADIUS = 25;
    private static final int START_X_CENTER = 300;
    private static final int START_Y_CENTER = 100;
    private static final int NUM_RESIDUES = 18;
    private static final int WENXIANG_GAP = 45;
    private static final int WENXIANG_SINGLE_ARC = 180;
    private static final double ROTATE_ANGLE = 1.7453292519943295;
    private static final double EPSILON = 1.0E-5;
    private static final int[] CENTER_POINT = new int[]{300, 325};
    private static final Color BG_COLOR = Color.WHITE;
    private static final Color LINE_COLOR = Color.BLACK;
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Font FONT_STUFF = new Font("Courier", 0, 20);
    private static final int FONT_X_L1 = 10;
    private static final int FONT_Y_L1 = 25;
    private static final int FONT_X_L2 = 10;
    private static final int FONT_Y_L2 = 45;
    private static int[][] WHEEL_RESID_CENTERS = new int[18][2];

    protected static void outputWenxiang(Sequence sequence, File file) {
        int n;
        if (sequence.length() > 19) {
            throw new IllegalArgumentException("Too many residues: " + sequence.length() + " (MAX = " + 19 + ")");
        }
        if (sequence.length() <= 1) {
            throw new IllegalArgumentException("Too few residues: " + sequence.length() + " (MIN = " + 2 + ")");
        }
        BufferedImage bufferedImage = new BufferedImage(600, 600, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(TEXT_COLOR);
        graphics2D.setFont(FONT_STUFF);
        graphics2D.drawString("Name:     " + sequence.getName(), 10, 25);
        graphics2D.drawString("Sequence: " + sequence.toString(), 10, 45);
        graphics2D.setColor(LINE_COLOR);
        int n2 = 100 * (sequence.length() - 1);
        int n3 = 233;
        int n4 = 278;
        int n5 = 45;
        int n6 = 0;
        for (n = 0; n < 10; ++n) {
            int n7 = n5 + n5;
            if ((double)n2 >= 180.0) {
                graphics2D.drawArc(n3, n4, n7, n7, n6, 180);
                if (n % 2 != 0) {
                    n3 -= 45;
                }
                n5 += 22;
                n4 -= 22;
                n2 -= 180;
            } else {
                graphics2D.drawArc(n3, n4, n7, n7, n6, n2);
                break;
            }
            n6 = (n6 + 180) % 360;
        }
        n = 300;
        int n8 = 322;
        int n9 = 22;
        int n10 = 25;
        int n11 = 0;
        double d = 0.0;
        double d2 = 1.7453292519943295;
        for (int i = 0; i < sequence.length(); ++i) {
            if (d % Math.PI < d2 && Math.abs(d % Math.PI - d2) > 1.0E-5) {
                n = n11 % 2 == 0 ? (n -= 22) : (n += 22);
                ++n11;
                n9 += 22;
            }
            int n12 = (int)((double)n + (double)n9 * Math.cos(d) + 0.5);
            int n13 = (int)((double)n8 - (double)n9 * Math.sin(d) + 0.5);
            Util.doCenterCircle(graphics2D, LINE_COLOR, sequence.residAt(i).residueColor(), n12, n13, 25);
            d += 1.7453292519943295;
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Something went wrong with the input/output of the wenxiang diagram.");
        }
    }

    protected static void outputWheel(Sequence sequence, File file) {
        int n;
        if (sequence.length() > 18) {
            throw new IllegalArgumentException("Too many residues: " + sequence.length() + " (MAX = " + 18 + ")");
        }
        if (sequence.length() <= 1) {
            throw new IllegalArgumentException("Too few residues: " + sequence.length() + " (MIN = " + 2 + ")");
        }
        BufferedImage bufferedImage = new BufferedImage(600, 600, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(BG_COLOR);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(TEXT_COLOR);
        graphics2D.setFont(FONT_STUFF);
        graphics2D.drawString("Name:     " + sequence.getName(), 10, 25);
        graphics2D.drawString("Sequence: " + sequence.toString(), 10, 45);
        graphics2D.setColor(LINE_COLOR);
        for (n = 0; n < sequence.length() - 1; ++n) {
            graphics2D.drawLine(WHEEL_RESID_CENTERS[n][0], WHEEL_RESID_CENTERS[n][1], WHEEL_RESID_CENTERS[n + 1][0], WHEEL_RESID_CENTERS[n + 1][1]);
        }
        for (n = 0; n < sequence.length(); ++n) {
            Util.doCenterCircle(graphics2D, LINE_COLOR, sequence.residAt(n).residueColor(), WHEEL_RESID_CENTERS[n][0], WHEEL_RESID_CENTERS[n][1], 37);
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Something went wrong with the input/output of the helical wheel.");
        }
    }

    private static int[] rotatePoint(int[] nArray, double d, int[] nArray2) {
        double d2 = nArray[0] - nArray2[0];
        double d3 = nArray[1] - nArray2[1];
        double d4 = d2 * Math.cos(d) - d3 * Math.sin(d);
        double d5 = d3 * Math.cos(d) + d2 * Math.sin(d);
        return new int[]{(int)((d4 += (double)nArray2[0]) + 0.5), (int)((d5 += (double)nArray2[1]) + 0.5)};
    }

    static {
        StaticVis.WHEEL_RESID_CENTERS[0] = new int[]{300, 100};
        for (int i = 1; i < WHEEL_RESID_CENTERS.length; ++i) {
            StaticVis.WHEEL_RESID_CENTERS[i] = StaticVis.rotatePoint(WHEEL_RESID_CENTERS[i - 1], 1.7453292519943295, CENTER_POINT);
        }
    }
}

