% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_wenxiang.R
\name{draw_wenxiang}
\alias{draw_wenxiang}
\title{Create Wenxiang diagrams to visualize alpha helical sequences.}
\usage{
draw_wenxiang(sequence, col = c("grey", "yellow", "blue", "red"))
}
\arguments{
\item{sequence}{character vector containing amino acid sequence
from N-terminus to C-terminus}

\item{col}{colors for each amino acid type in the following order:
nonpolar residues, polar residues, basic residues, acidic residues}
}
\description{
This function visualizes alpha-helical peptides as
Wenxiang diagrams.
Sequences between 2 and 18 (inclusive) characters can be visualized.
The residue closest to the center represents the amino acid at the
N-terminus (first in `sequence`).
}
\examples{
draw_wenxiang("GIGAVLKVLTTGLPALIS")
draw_wenxiang("QQRKRKIWSILAPLGTTL")
}
