% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_city_map.R
\name{get_city_map}
\alias{get_city_map}
\title{Get city administrative regions}
\source{
Metropolitan area in districts: <https://hri.fi/data/fi/dataset/paakaupunkiseudun-aluejakokartat>
}
\usage{
get_city_map(city = NULL, level = NULL)
}
\arguments{
\item{city}{The desired city. Options: Helsinki, Espoo, Vantaa, Kauniainen}

\item{level}{The desired administrative level. Options are: "suurpiiri", 
"tilastoalue", "pienalue" and "aanestysalue"}
}
\value{
sf object
}
\description{
Sf object of city districts
}
\details{
See list_features() for a list of all available features
}
\examples{
\dontrun{
map <- get_city_map(city = "helsinki", level = "suuralue")
}

}
\author{
Pyry Kantanen <pyry.kantanen@gmail.com>
}
