% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geocode.R
\name{reverse_geocode}
\alias{reverse_geocode}
\title{HERE Geocoder API: Reverse Geocode}
\usage{
reverse_geocode(poi, results = 1, landmarks = FALSE,
  url_only = FALSE)
}
\arguments{
\item{poi}{\code{sf} object, Points of Interest (POIs) of geometry type \code{POINT}.}

\item{results}{numeric, maximum number of results (Valid range: 1 and 20).}

\item{landmarks}{boolean, retrieve landmarks instead of addresses (\code{default = FALSE})?.}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object, containing the suggested addresses or landmark names of the reverse geocoded POIs.
}
\description{
Get addresses or landmarks from locations using the 'Geocoder' API.
The return value is an \code{sf} object, containing point geometries
with suggestions for addresses or landmarks near the provided POIs.
}
\note{
If no addresses or landmarks are found near a POI, \code{NULL} for this POI is returned.
In this case the rows corresponding to this particular POI are missing and merging the POIs by row is not possible.
However, in the returned \code{sf} object, the column \code{"id"} matches the rows of the input POIs.
The \code{"id"} column can be used to join the original POIs.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

# Get addresses
addresses <- reverse_geocode(poi = poi, results = 3, landmarks = FALSE, url_only = TRUE)

# Get landmarks
landmarks <- reverse_geocode(poi = poi, results = 3, landmarks = TRUE, url_only = TRUE)
}
\references{
\href{https://developer.here.com/documentation/geocoder/topics/resource-geocode.html}{HERE Geocoder API: Geocode}
}
