% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdiffpen.R
\name{spdiffpen}
\alias{spdiffpen}
\title{Spatial difference penalty}
\usage{
spdiffpen(coords, m = 1, sparse = TRUE, longlat = FALSE, digits = 1)
}
\arguments{
\item{coords}{A two-dimensional matrix-like object with
non-NULL dimensions.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{longlat}{A logical value indicating whether Great
Circle distances should be used (\code{TRUE}) or
Euclidean distances (\code{FALSE}).  The default is
\code{FALSE}.}

\item{digits}{The number of digits to use when applying
\code{\link[base]{round}} to the distances.}
}
\value{
A \code{\link[base]{matrix}} or \code{\link[Matrix]{sparseMatrix-class}} object.
}
\description{
\code{spdiffpen} computes the \code{m}th order spatial
difference penalty for a set of coordinates.
}
\details{
\code{\link{adjacent}} is used to determine the
first-order neighbors of each point in \code{coords}. The
difference penalties are then successively determined
from that.

If \code{sparse = TRUE}, a
\code{\link[Matrix]{sparseMatrix-class}} Matrix is
returned when the penalty matrix is relatively sparse
(typically, at least half the entries are zero).
Otherwise, something of the more general
\code{\link[Matrix]{Matrix-class}} is returned.
}
\examples{
coords = expand.grid(1:4, 1:4)
# first order difference penalty
d1 = spdiffpen(coords, digits = 1)
# second order difference penalty
d2 = spdiffpen(coords, m = 2, digits = 1)
# third order difference penalty
d3 = spdiffpen(coords, m = 3, digits = 1)
}
