% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_mean}
\alias{params_mean}
\title{Parameters of a mean model}
\usage{
params_mean(mu, sigma = NULL)
}
\arguments{
\item{mu}{Matrix of samples from the posterior distribution of the 
mean. Columns denote random samples and rows denote means for different observations.}

\item{sigma}{A vector of samples of the standard deviation.}
}
\value{
An object of class "params_mean", which is a list containing \code{mu},
\code{sigma}, and \code{n_samples}.
 \code{n_samples} is equal to the number of columns in \code{mu}.
}
\description{
Create a list containing the parameters of a mean model.
}
\details{
The mean model is given by,
\deqn{y_j = \mu_j + \epsilon,}
where \eqn{\mu_j} is the mean value for observation \eqn{j}. Predicted means
are consequently given by \eqn{\hat{\mu}_j}, which is an estimate of
\eqn{\mu_j} from the available data.  Random samples are obtained by sampling 
the error term from a normal distribution,  
\eqn{\epsilon \sim N(0, \hat{\sigma}^2)}{\epsilon ~ N(0, \hat{\sigma}^2)}.
}
\examples{
params <- params_mean(mu = matrix(seq(1, 4), nrow = 2), 
                      sigma = c(0, 0))
print(params)

}
