% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{onc3p}
\alias{onc3p}
\title{Multi-state panel oncology data for 3-state model}
\format{
A \code{data.table} with the following columns:
\describe{
\item{state}{The name of the health state (Stable, Progression,
and Death).}
\item{strategy_name}{Standard of care (SOC), new treatment 1 (New 1), or
new treatment 2 (New 2).}
\item{female}{1 if a patient is female; 0 if male.}
\item{age}{Patient age (in years).}
\item{patient_id}{Patient identification number.}
\item{time}{Time that \code{state} was recorded.}
\item{strategy_id}{Strategy identification number.}
\item{state_id}{The health state identification number.}
}
}
\usage{
onc3p
}
\description{
The same dataset as \link{onc3} converted into a panel data format in which health
states are recorded at a finite series of times.
}
\examples{
head(onc3p)
}
\seealso{
\link{onc3}
}
\keyword{datasets}
