% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cue_validity.R
\name{cueValidityAppliedToColumns}
\alias{cueValidityAppliedToColumns}
\title{Calculate the cue validity for the cols_to_fit columns.}
\usage{
cueValidityAppliedToColumns(data, criterion_col, cols_to_fit,
  replaceNanWith = 0.5)
}
\arguments{
\item{data}{The matrix or data.frame whose columns are treated as cues.}

\item{criterion_col}{The index of the column used as criterion.}

\item{cols_to_fit}{A vector of indexes of the columns to calculate cue
validity for.}

\item{replaceNanWith}{The value to return as cue validity in case it
cannot be calculated.}
}
\value{
A list where $cue_validities has a vector of validities for
  each of the columns in cols_to_fit.
}
\description{
This returns only the cue validities, without reversing when a cue
points in the wrong direction-- e.g. education is negatively associated
with number of felonies, so we should use LESS education as a predictor.
Use cueValidityComplete for help with that.
}
\references{
Wikipedia's entry on
\url{https://en.wikipedia.org/wiki/Cue_validity}
}
\seealso{
\code{\link{cueValidityComplete}} for more complete output.
}
