% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetero.R
\name{spatial_hetero_test}
\alias{spatial_hetero_test}
\title{Test the spatial heterogeneity in data based on permutation.}
\usage{
spatial_hetero_test(
  x,
  coords,
  ...,
  resample = 5000,
  poly = 2,
  bw = 10,
  kernel = c("bisquared", "gaussian"),
  verbose = 0
)
}
\arguments{
\item{x}{A matrix of data to be tested. Each column is a variable.}

\item{coords}{A matrix of coordinates.}

\item{\dots}{Additional arguments.}

\item{resample}{The total times of resampling with replacement. Default to 5000.}

\item{poly}{The number of polynomial terms used by the polynomial estimator. Default to 2.}

\item{bw}{The adaptive bandwidth used by the polynomial estimator. Default to 10.}

\item{kernel}{The kernel function used by the polynomial estimator.}

\item{verbose}{The verbosity level. Default to 0.}
}
\value{
A \code{shgt} object of permutation-test results with the following items:
\describe{
\item{\code{vars}}{The names of variables.}
\item{\code{t0}}{The value of the statistics (variance of density estimation) on original values.}
\item{\code{t}}{The value of the same statistics on permuted values.}
\item{\code{p}}{The p-value for each variable.}
}
}
\description{
Test the spatial heterogeneity in data based on permutation.
}
\examples{
data(multisampling.large)
spatial_hetero_test(multisampling.large$beta, multisampling.large$coords)

}
