\name{ftspec_image}
\alias{ftspec_image}
\title{Display Fourier spectrogram}
\description{
This function displays a Fourier spectrogram using the same plot structure and options as \code{\link{hhspec_image}}.
It depends on functions contained in the \code{RSEIS} package to work.
}
\usage{
ftspec_image(ft, time_span, freq_span, amp_span, amp_units=NULL, 
     amp_unit_conversion=NULL, grid=TRUE, colorbar=TRUE, 
     backcol=c(0, 0, 0), pretty=TRUE, cex=1, main="")
}
\arguments{
\item{ft}{Data structure to pass to \code{RSEIS} to generate the Fourier spectrogram.}
\itemize{
    \item{\code{ft$xt} is the signal to be processed}
    \item{\code{ft$dt} is the sample rate}
    \item{\code{ft$nfft} is the fft length}
    \item{\code{ft$ns} is the number of samples in a window}
    \item{\code{ft$nov} is the number of samples to overlap}}
\item{time_span}{Time span to render spectrogram over.  \code{c(0, -1)} will draw the spectrogram over the entire signal.}
\item{freq_span}{Frequency span to render spectrogram over.  \code{c(0, -1)} plots everything up to the Nyquist frequency.}
\item{amp_span}{Amplitude range to plot.  \code{c(0, -1)} plots everything.}
\item{amp_units}{What to call the amplitude units.}
\item{amp_unit_conversion}{How to convert amplitude units of the input signal to amplitude units on the image}
\item{grid}{Boolean - whether to display grid lines or not}
\item{colorbar}{Boolean - whether to display amplitude colorbar or not}
\item{backcol}{What background color to use behind the spectrogram, in a 3 element vector: \code{c(red, green, blue)}}
\item{pretty}{Boolean - to choose nice axes values or to use exactly the ranges given}
\item{cex}{Font scaling.}
\item{main}{Title of main plot}
}

\details{
This function is a simple Fourier spectrogram plotter.
It's useful to compare this image with images generated by \code{\link{hhspec_image}} to see how the Fourier and Hilbert spectrograms differ.
}

\references{Jonathan M. Lees (2012). RSEIS: Seismic Time Series Analysis Tools. R
  package version 3.0-6. http://CRAN.R-project.org/package=RSEIS}

\author{Daniel Bowman \email{daniel.bowman@unc.edu}}

\seealso{
\code{\link{hhspec_image}}
}
\examples{
data(port_foster_event)

ft=list()
ft$xt=sig
ft$dt=dt
ft$nfft=4096
ft$ns=30
ft$nov=29

time_span=c(5, 10)
freq_span=c(0, 25)
amp_span=c(1e-5, 0.0003)
ftspec_image(ft, time_span, freq_span, amp_span)
}

\keyword{nonparametric}
