% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts-ts-xts.R
\name{hc_add_series_ts}
\alias{hc_add_serie_ts}
\alias{hc_add_series_ts}
\title{Shorcut for create/add time series charts from a ts object}
\usage{
hc_add_series_ts(hc, ts, ...)

hc_add_serie_ts(hc, ts, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{ts}{A time series object.}

\item{...}{Aditional arguments for the data series (\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function add a time series to a \code{highchart} object
from a \code{ts} object.
}
\details{
This function \bold{modify} the type of \code{chart} to \code{datetime}
}
\examples{

highchart() \%>\% 
  hc_title(text = "Monthly Airline Passenger Numbers 1949-1960") \%>\% 
  hc_subtitle(text = "The classic Box and Jenkins airline data") \%>\% 
  hc_add_series_ts(AirPassengers, name = "passengers") \%>\%
  hc_tooltip(pointFormat =  '{point.y} passengers')

highchart() \%>\% 
  hc_title(text = "Monthly Deaths from Lung Diseases in the UK") \%>\% 
  hc_add_series_ts(fdeaths, name = "Female") \%>\%
  hc_add_series_ts(mdeaths, name = "Male")
  
}

