% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hchart-shorcuts.R
\name{hciconarray}
\alias{hciconarray}
\title{Shortcut to make icon arrays charts}
\usage{
hciconarray(labels, counts, rows = NULL, icons = NULL, size = 4, ...)
}
\arguments{
\item{labels}{A character vector}

\item{counts}{A integer vector}

\item{rows}{A integer to set}

\item{icons}{A character vector same length (o length 1) as labels}

\item{size}{Font size}

\item{...}{Additional arguments for the data series \url{http://api.highcharts.com/highcharts#series}.}
}
\description{
Shortcut to make icon arrays charts
}
\examples{

hciconarray(c("nice", "good"), c(10, 20))

hciconarray(c("nice", "good"), c(10, 20), size = 10)

hciconarray(c("nice", "good"), c(100, 200), icons = "child")

hciconarray(c("car", "truck", "plane"), c(75, 30, 20), icons = c("car", "truck", "plane")) \%>\%
  hc_add_theme(
    hc_theme_merge(
      hc_theme_flatdark(),
      hc_theme_null(chart = list(backgroundColor = "#34495e"))
    )
  )
}
