% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rKernelCov}
\alias{rKernelCov}
\title{Realized kernel estimator}
\usage{
rKernelCov(
  rData,
  cor = FALSE,
  alignBy = "seconds",
  alignPeriod = 1,
  makeReturns = FALSE,
  kernelType = "rectangular",
  kernelParam = 1,
  kernelDOFadj = TRUE
)
}
\arguments{
\item{rData}{an \code{xts} or \code{data.table} object containing returns or prices, possibly for multiple assets over multiple days}

\item{cor}{boolean, in case it is \code{TRUE}, and the input data is multivariate, the correlation is returned instead of the covariance matrix. 
\code{FALSE} by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. 
For example, to aggregate based on a 5-minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}

\item{kernelType}{Kernel name.}

\item{kernelParam}{Kernel parameter.}

\item{kernelDOFadj}{Kernel degree of freedom adjustment.}
}
\value{
in case the input is and contains data from one day, an \eqn{N} by \eqn{N} matrix is returned. 
If the data is a univariate \code{xts} object with multiple days, an \code{xts} is returned.
If the data is multivariate and contains multiple days (\code{xts} or \code{data.table}), the function returns a list containing \eqn{N} by \eqn{N} matrices. 
Each item in the list has a name which corresponds to the date for the matrix.
}
\description{
Realized covariance calculation using a kernel estimator. 
The different types of kernels available can be found using \code{\link{listAvailableKernels}}.
}
\details{
Let \eqn{r_{t,i}} be \eqn{N} returns in period \eqn{t}, \eqn{i = 1, \ldots, N}. The returns or prices 
do not have to be equidistant. The kernel estimator for \eqn{H = \code{kernelParam}} is given by
\deqn{
\gamma_0 + 2 \sum_{h = 1}^H k \left(\frac{h-1}{H}\right) \gamma_h,
}
where \eqn{k(x)} is the chosen kernel function and 
\deqn{
\gamma_h = \sum_{i = h}^N r_{t,i} \times r_{t,i-h}
}
is the empirical autocovariance function. The multivariate version employs the cross-covariances instead.
}
\examples{
# Univariate:
rvKernel <- rKernelCov(rData = sampleTData[, list(DT, PRICE)], alignBy = "minutes",
                       alignPeriod = 5, makeReturns = TRUE)
rvKernel

# Multivariate:
rcKernel <- rKernelCov(rData = sampleOneMinuteData, makeReturns = TRUE)
rcKernel

}
\references{
Barndorff-Nielsen, O. E., Hansen, P. R., Lunde, A., and Shephard, N. (2008). Designing realized kernels to measure the ex post variation of equity prices in the presence of noise. \emph{Econometrica}, 76, 1481-1536.

Hansen, P. and Lunde, A. (2006). Realized variance and market microstructure noise. \emph{Journal of Business and Economic Statistics}, 24, 127-218.

Zhou., B. (1996). High-frequency data and volatility in foreign-exchange rates. \emph{Journal of Business & Economic Statistics}, 14, 45-52.
}
\author{
Scott Payseur, Onno Kleen, and Emil Sjoerup.
}
\keyword{volatility}
