% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivative_functions.R
\name{directional_proposal}
\alias{directional_proposal}
\title{Emulated Derivative Point Proposal}
\usage{
directional_proposal(
  ems,
  x,
  targets,
  accept = 2,
  hstart = 1e-04,
  hcutoff = 1e-09,
  iteration.measure = "exp",
  iteration.steps = 100,
  nv = 500
)
}
\arguments{
\item{ems}{The emulators to evaluate with respect to.}

\item{x}{The original point.}

\item{targets}{The list of emulator targets.}

\item{accept}{The implausibility below which we allow an output to worsen.}

\item{hstart}{The initial step size.}

\item{hcutoff}{The minimum allowed step size.}

\item{iteration.measure}{Either `exp' for expectation or `imp' for implausibility.}

\item{iteration.steps}{The number of allowed iterations.}

\item{nv}{The number of directions on the n-sphere to try.}
}
\value{
Either a new proposal point, or the original point if an improvement could not be found.
}
\description{
Proposes a new point by applying `emulated gradient descent' on an existing point.
}
\details{
Given a point (preferably close to the implausibility boundary) \code{x}, we can calculate
the emulated gradient at this point for each emulator. If the estimate of the expectation
at this point for a given emulator is larger than the target value, then we would like to
move in the direction of greatest decrease for this emulator, and conversely for an estimate
of the expectation that's smaller than the target value. The combination of this information
for every emulator under consideration defines a preferred set of directions of travel from
this point.

We may try to find a shared direction which improves (or at least does not worsen) all
emulator evaluations. If a point is already well inside the implausibility boundary for a given
output (where `well inside' is defined by the value of \code{accept}), we may allow this
output to worsen in order to improve the others.

Provided a shared direction, v, can be identified, we iteratively move in this direction. Define
the new proposed point x' = x + h*v, where h is a step-size given by \code{hstart}. Compare
the summary statistic (either expectational difference or implausibility) to that provided by
the original point; if the new point gives improvement, then continue to move in this direction
until no further improvement is possible for this step-size. The step-size is reduced (up to
a minimum of \code{hcutoff}) and the process is repeated. Only finitely many iteration steps
are permitted; this can be tuned by supplying a value of \code{iteration.steps}.
}
\examples{
 # Take a point from the SIR system at later waves with low (but >3) implausibility
 start_point <- SIRMultiWaveData[[2]][90,1:3]
 ems <- SIRMultiWaveEmulators[[3]]
 targs <- SIREmulators$targets
 # Using expected error as measure
 new_point1 <- directional_proposal(ems, start_point, targs)
 # Using implausibility as measure
 new_point2 <- directional_proposal(ems, start_point, targs, iteration.measure = 'imp')
 all_points <- do.call('rbind.data.frame', list(start_point, new_point1, new_point2))
 nth_implausible(ems, all_points, targs)

}
