% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residual_diag}
\alias{residual_diag}
\title{Emulator Regression Residuals}
\usage{
residual_diag(emulator, histogram = FALSE, ...)
}
\arguments{
\item{emulator}{The emulator to consider.}

\item{histogram}{Should a histogram or a scatter plot be shown? Default: FALSE}

\item{...}{Any additional arguments (used internally)}
}
\value{
A set of residuals, standardised by the regression surface residual standard error.
}
\description{
Plots the emulator residuals.
}
\details{
An emulator is composed of two parts: a global regression surface, and a local
correlation structure. It can sometimes be informative to examine the residuals
of the regression surface on the training set, to determine the extent to which
the regression surface is being `corrected for' by the correlation structure.
}
\examples{
residual_diag(SIREmulators$ems$nS)
residual_diag(SIREmulators$ems$nI, TRUE)

}
\seealso{
Other diagnostic functions: 
\code{\link{analyze_diagnostic}()},
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{get_diagnostic}()},
\code{\link{individual_errors}()},
\code{\link{standard_errors}()},
\code{\link{summary_diag}()},
\code{\link{validation_diagnostics}()}
}
\concept{diagnostic functions}
