% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulafunctions.R
\name{dmdistr}
\alias{dmdistr}
\title{Copula density Function for multivariate data}
\usage{
dmdistr(x, params, corr = diag(ncol(x)), distr)
}
\arguments{
\item{x}{a n x d matrix containing the multivariate data}

\item{params}{a list of D elements corresponding to the   matrices corresponding to the parameters:}

\item{corr}{a matrix containing the correlation parameters of the multivariate distribution related to the states of the HMM;}

\item{distr}{a vector containing the distribution for each component, "gaussian" for the normal distribution, "gamma" for the gamma distribution, "exp" for the exponential distribution}
}
\value{
The function returns a numeric value corresponding to the value of the density of the multivariate distribution where the dependence is computed using a copula.
}
\description{
This function returns the value of a multivariate density defined on a gaussian copula
}
\examples{
#Load the copuladata
data(copuladata)
params <- list(t(c(1.5, 1)), as.matrix(0.5))
corr <- cbind(c(1,0.7), c(0.7,1))
distr <- c("gaussian", "exp")

density <- dmdistr(copuladata, params = params, corr = corr, distr = distr)
}
\references{
Song, P. X.-K.(2000). Multivariate dispersion models generated from Gaussian copula. Scandinavian Journal of Statistics, 27(2), 305-320.
}
