% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_draft_class.R
\name{get_draft_class}
\alias{get_draft_class}
\title{Get draft classes}
\usage{
get_draft_class(
  draft_year = as.numeric(format(Sys.Date() - 181, "\%Y")),
  player_details = FALSE
)
}
\arguments{
\item{draft_year}{Draft year to scrape}

\item{player_details}{If true, returns more detailed data on each prospect}
}
\value{
A tibble containing all selections for the supplied draft year.
\subsection{Basic draft class variables}{
\itemize{
\item Draft year
\item Round
\item Overall Pick #
\item Round Pick #
\item Drafting team
\item Player ID
\item Player name
\item Player link
}
}

\subsection{Detailed draft class variables}{
\itemize{
\item Player birthdate
\item Player birthplace & nationality
\item Player height & weight
\item Player shoots/catches
\item Player position
\item Player amateur team & league
}
}
}
\description{
Get all selections for any single NHL draft class back to 1963
}
\examples{
\dontrun{
draft_2022 <- get_draft_class(draft_year = 2022, player_details = TRUE)
}
}
