% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{linear}
\alias{linear}
\title{Linear Constraint}
\usage{
linear(L, dir, rhs, on_big_m = FALSE)
}
\arguments{
\item{L}{a named vector or matrix defining the linear constraints on the coefficients of the covariates.}

\item{dir}{a character vector giving the direction of the linear constraints.}

\item{rhs}{a numeric vector giving the right hand side of the linear constraint.}

\item{on_big_m}{a logical indicating if the constraint should be imposed on the big-M related binary variables.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Linear Constraint
}
\examples{
# vector constraint
beta <- c(1, -2, 3)
dat <- rhglm(100, beta)
constraints <- c(linear(c(x1 = 2, x2 = 1), "==", 0), rho_max(1))
hglm(y ~ ., data = dat, constraints = constraints)

# matrix constraint
dat <- rhglm(100, c(1, -2, 3, 4, 5, 6, 7))
mat <- diag(2)
colnames(mat) <- c("x1", "x5")
constraints <- c(linear(mat, c("==", "=="), c(-1, 3)), rho_max(1))
hglm(y ~ ., data = dat, constraints = constraints)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
