% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circ_test.R
\name{Circ_test}
\alias{Circ_test}
\title{Running Mplus for testing empirical RIASEC angular locations}
\usage{
Circ_test(
  N,
  Cor,
  test = "perfect",
  w = FALSE,
  showOutput = TRUE,
  Mplus_command = "Mplus",
  replaceOutfile = "always",
  name = NULL,
  ...
)
}
\arguments{
\item{N}{number of observations for correlations as numeric}

\item{Cor}{either an R matrix object with RIASEC correlations or the name of a correlation matrix, stored as a .dat text file, as character (see details).}

\item{test}{either character (default test="perfect"), whicht tests against a perfect circumplex array, or a numeric vector with length = 6 giving the six angular locations (in radians) to test against.}

\item{w}{logical - write fit coefficiants as csv table? - default: \code{w = FALSE}.}

\item{showOutput}{default set to \code{TRUE} - see description of the function \code{runModels()} in package \code{\link[MplusAutomation]{MplusAutomation}}.}

\item{Mplus_command}{default set to \code{"Mplus"} as in the default in \code{\link[MplusAutomation]{MplusAutomation}} - see examples and see description of the function \code{runModels()} in package \code{\link[MplusAutomation]{MplusAutomation}}.}

\item{replaceOutfile}{default set to "always" - see description of the function \code{runModels()} in package \code{\link[MplusAutomation]{MplusAutomation}}.}

\item{name}{optional a name (as character) for the Mplus syntax to be saved - default is the object name or the name given in paramter \code{Cor} as character (with ending changed to '.inp').}

\item{...}{additional parameters passed through}
}
\value{
a list with coefficients for model fit extracted from the Mplus result file after running the Mplus syntax.
}
\description{
This function generates and runs Mplus syntax which is discussed in Nagy et. al. (2009) and extracts the estimated model fit - tested against given (perfect - as default) angular locations of the six RIASEC dimensions, based on their correlations, in the asumed circumplex array within the theory of vocational choice by John Holland (1997).
}
\details{
more to come ...
}
\examples{
# generating running and extraction of Mplus files 
# refering to a correlation data stored object example2
data(example2) # loading fictional example correlation matrix
# not Run until Mplus is installed on your System #####
\dontrun{test <- Circ_test(N = 300, Cor = example2, test="perfect") 
test}
}
\references{
Holland, J.L. (1997). \emph{Making vocational choices. A theory of vocational personalities and work environments}. Lutz, FL: Psychological Assessment Resources.

Nagy, G., Marsh, H. W., Luedtke, O., & Trautwein, U. (2009). Representing circles in our minds: Confirmatory factor analysis of circumplex structures and profiles. In T. Teo & M. S. Khine (Hrsg.), \emph{Structural Equation Modeling in Educational Research: Concepts and applications} (S. 287 - 315). Rotterdam Boston Taipei: Sense Publishers.
}
\keyword{calculus}
