% Generated by roxygen2 (4.0.2): do not edit by hand
\name{prPrepareCgroup}
\alias{prPrepareCgroup}
\title{Prepares the cgroup argument}
\usage{
prPrepareCgroup(x, cgroup, n.cgroup, align.cgroup, css.cgroup)
}
\arguments{
  \item{x}{The matrix/data.frame with the data}

  \item{cgroup}{A vector or a matrix of character strings
  defining major column header. The default is to have
  none. These elements are also known as \emph{column
  spanners}. If you want a column \emph{not} to have a
  spanner then put that column as "". If you pass cgroup
  and \code{n.crgroup} as matrices you can have column
  spanners for several rows. See cgroup section below for
  details.}

  \item{n.cgroup}{An integer vector or matrix containing
  the number of columns for which each element in cgroup is
  a heading. For example, specify \code{cgroup=c("Major
  1","Major 2")}, \code{n.cgroup=c(3,3)} if \code{"Major
  1"} is to span columns 1-3 and \code{"Major 2"} is to
  span columns 4-6. \code{rowlabel} does not count in the
  column numbers. You can omit \code{n.cgroup} if all
  groups have the same number of columns.}

  \item{align.cgroup}{The justification of the
  \code{cgroups}}

  \item{css.cgroup}{The same as \code{css.class} but for
  cgroup formatting.}
}
\value{
\code{list(cgroup, n.cgroup, align.cgroup,
cgroup_spacer_cells)}
}
\description{
Due to the complicated structure of multilevel cgroups
there some preparation for the cgroup options is required.
}
\seealso{
Other hidden helper functions for \code{\link{htmlTable}}:
\code{\link{prAddCells}};
\code{\link{prAddSemicolon2StrEnd}};
\code{\link{prGetCgroupHeader}};
\code{\link{prGetRowlabelPos}}; \code{\link{prGetStyle}};
\code{\link{prPrepareAlign}}; \code{\link{prTblNo}}
}
\keyword{internal}

