% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_weightedsum.R
\name{h_weightedsum}
\alias{h_weightedsum}
\title{Weighted sum of time-series}
\usage{
h_weightedsum(files, weights, constant = 0)
}
\arguments{
\item{files}{List of file names to proceed}

\item{weights}{List of weights (must have the same length as files)}

\item{constant}{Constant to add (default = 0)}
}
\value{
The function returns
+ n hts files with the extracted common period
+ 1 hts file named as the first file of the list
with the prefix w_. The sensor id is automatically set to "weighted".
}
\description{
The function only works on the common period of the files without NA values. It
operates weighted sums on one or several time-series. It is also possible to add a constant.
}
\details{
For averaging n time-series one can use n weights wit a value of 1/n and constant = 0.
}
\examples{
\dontrun{

# choose time-series f1, f2, f3
f1 <- "foo1.hts" ; f2 <- "foo2.hts" ; f3 <- "foo3.hts"
# the new f time-series contains records f[i] = f1[i] - (0.5 * f2[i]) + (0.5 * f3[i]) + 5
f <- h_weightedsum(c(f1,f2,f3), c(1,-0.5,0.5)), 5)
# the new f time-series contains records f[i] = (1.12 * f1[i]) + 3
f <- h_weightedsum(f1, 1.12, 3)
}

}
\author{
P. Chevallier - Oct 2017-Nov 2020
}
