% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_url}
\alias{hgd_url}
\title{httpgd URL.}
\usage{
hgd_url(
  endpoint = "live",
  which = dev.cur(),
  host = NA,
  port = NA,
  explicit = FALSE,
  omit_token = FALSE,
  ...
)
}
\arguments{
\item{endpoint}{API endpoint. The default, \code{"live"} is the HTML/JS
plot viewer. Can be set to a numeric plot index or plot ID
(see \code{\link[unigd:ugd_id]{unigd::ugd_id()}}) to obtain the direct URL to the SVG.}

\item{which}{Which device (ID).}

\item{host}{Replaces hostname.}

\item{port}{Replaces port.}

\item{explicit}{Ads \code{hgd={host}:{port}} query parameter. Needed for host
resolution in some editors.}

\item{omit_token}{Should the security token be omitted from the URL.}

\item{\\dots}{Other query parameters that will be appended to the URL.}
}
\value{
URL.
}
\description{
Generate URLs to the plot viewer or to plot SVGs.
This function will only work after starting a device with \code{\link[=hgd]{hgd()}}.
}
\details{
Note: If the included client is used set \code{websockets=0} or
\code{sidebar=0} to turn off WebSocket or plot history sidebar.
}
\examples{
\dontrun{

hgd()
my_url <- hgd_url()
hgd_url(0)
hgd_url(plot_id(), width = 800, height = 600)

dev.off()
}
}
