% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi-req.R
\name{multi_req_perform}
\alias{multi_req_perform}
\title{Perform multiple requests in parallel}
\usage{
multi_req_perform(reqs, paths = NULL, pool = NULL, cancel_on_error = FALSE)
}
\arguments{
\item{reqs}{A list of \link{request}s.}

\item{paths}{An optional list of paths, if you want to download the request
bodies to disks. If supplied, must be the same length as \code{reqs}.}

\item{pool}{Optionally, a curl pool made by \code{\link[curl:multi]{curl::new_pool()}}. Supply
this if you want to override the defaults for total concurrent connections
(100) or concurrent connections per host (6).}

\item{cancel_on_error}{Should all pending requests be cancelled when you
hit an error. Set this to \code{TRUE} to stop all requests as soon as you
hit an error. Responses that were never performed will have class
\code{httr2_cancelled} in the result.}
}
\value{
A list the same length as \code{reqs} where each element is either a
\link{response} or an \code{error}.
}
\description{
This variation on \code{\link[=req_perform]{req_perform()}} performs multiple requests in parallel.
Unlike \code{req_perform()} it always succeeds; it will never throw an error.
Instead it will return error objects, which are your responsibility to
handle.

Exercise caution when using this function; it's easy to pummel a server
with many simultaneous requests. Only use it with hosts designed to serve
many files at once.
}
\section{Limitations}{
\itemize{
\item Will not retrieve a new OAuth token if it expires part way through
the requests.
\item Does not perform throttling with \code{\link[=req_throttle]{req_throttle()}}.
\item Does not attempt retries as described by \code{\link[=req_retry]{req_retry()}}.
\item Consults the cache set by \code{\link[=req_cache]{req_cache()}} before/after all requests.
}

In general, where \code{\link[=req_perform]{req_perform()}} might make multiple requests due to retries
or OAuth failures, \code{multi_req_perform()} will make only make 1.
}

\examples{
# Requesting these 4 pages one at a time would take four seconds:
reqs <- list(
  request("https://httpbin.org/delay/1"),
  request("https://httpbin.org/delay/1"),
  request("https://httpbin.org/delay/1"),
  request("https://httpbin.org/delay/1")
)
# But it's much faster if you request in parallel
system.time(resps <- multi_req_perform(reqs))

reqs <- list(
  request("https://httpbin.org/status/200"),
  request("https://httpbin.org/status/400"),
  request("FAILURE")
)
# multi_req_perform() will always succeed
resps <- multi_req_perform(reqs)
# you'll need to inspect the results to figure out which requests fails
fail <- vapply(resps, inherits, "error", FUN.VALUE = logical(1))
resps[fail]
}
