% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-progress.R
\name{req_progress}
\alias{req_progress}
\title{Add a progress bar to long downloads or uploads}
\usage{
req_progress(req, type = c("down", "up"))
}
\arguments{
\item{req}{A \link{request}.}

\item{type}{Type of progress to display: either number of bytes uploaded
or downloaded.}
}
\description{
When uploading or downloading a large file, it's often useful to
provide a progress bar so that you know how long you have to wait.
}
\examples{
req <- request("https://r4ds.s3.us-west-2.amazonaws.com/seattle-library-checkouts.csv") |>
  req_progress()

\dontrun{
path <- tempfile()
req |> req_perform(path = path)
}
}
