% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydrometrie.R
\name{get_hydrometrie_obs_elab}
\alias{get_hydrometrie_obs_elab}
\alias{get_hydrometrie_observations_tr}
\alias{get_hydrometrie_sites}
\alias{get_hydrometrie_stations}
\title{Retrieve data from API "Hydrométrie"}
\usage{
get_hydrometrie_obs_elab(...)

get_hydrometrie_observations_tr(..., entities = "station")

get_hydrometrie_sites(..., unique_site = TRUE)

get_hydrometrie_stations(..., code_sandre_reseau_station = FALSE)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}

\item{entities}{1-length \link{character} string filtering the rows of the returned value, possible values are: "station" for filtering on station rows, "site" for filtering on site rows, "both" for keeping all the rows}

\item{unique_site}{optional \link{logical}, if set to \code{FALSE} sites with several different locations produce one row by different location otherwise the first location found is used for fields \code{code_commune_site}, \code{libelle_commune}, \code{code_departement}, \code{code_region}, \code{libelle_region}, \code{libelle_departement}}

\item{code_sandre_reseau_station}{optional \link{logical} indicating
if \code{code_sandre_reseau_station} field is included in the result;
if so, one line is added by item and other fields are repeated}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
Available endpoints are:
\itemize{
\item \code{get_hydrometrie_obs_elab} retrieves hydrometric elaborate observations (daily/monthly mean flow)
\item \code{get_hydrometrie_observations_tr} retrieves hydrometric "real time" observations ()
\item \code{get_hydrometrie_sites} retrieves hydrometric sites
\item \code{get_hydrometrie_stations} retrieves hydrometric stations
}

See the API documentation of each endpoint for available filter parameters:
\url{https://hubeau.eaufrance.fr/page/api-hydrometrie}
}
\examples{
\dontrun{
# Retrieve the hydrometric sites in the department of Aube
get_hydrometrie_sites(code_departement = "10")

# The same operation returning 2 rows for the site 'H0203020' which has 2 different locations
get_hydrometrie_sites(code_departement = "10", unique_site = FALSE)

# Retrieve the hydrometric stations in the department of Aube
get_hydrometrie_stations(code_departement = "10")

# Which parameters are available for endpoint "obs_elab" of API "hydrometrie"?
list_params("hydrometrie", "obs_elab")

# Retrieve the hydrometric monthly mean flow at site 'H0203020'
get_hydrometrie_obs_elab(code_entite = "H0203020", grandeur_hydro_elab = "QmM")

# Retrieve the hydrometric daily mean flow at site 'H0203020' of the last 30 days
get_hydrometrie_obs_elab(code_entite = "H0203020",
                         date_debut_obs_elab = format(Sys.Date() -30, "\%Y-\%m-\%d"),
                         grandeur_hydro_elab = "QmJ")
}
}
