% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{rs.to.id}
\alias{rs.to.id}
\title{Convert from dbSNP rs-ids to chip ID labels}
\usage{
rs.to.id(rs.ids, manifest = FALSE, multi.list = TRUE, force.flat = TRUE)
}
\arguments{
\item{rs.ids}{character, meant to be a list of rs-ids, but if chip-ids are present they will not be
altered.}

\item{manifest}{logical, if TRUE return the ids as specified by the manifest/official set, or as
stored in the column 'chip.id'. If FALSE return the IDs as stored in the rownames of the ChipInfo
object, which can differ when the chip.id is an illegal format for an R row/column name.}

\item{multi.list}{logical, some rs-ids could map to multiple chip ids. It is recommended that if
that is the case then a letter should be appended to duplicate rs-ids to make them unique in the
ChipInfo object, e.g, rs1234, rs1234b, rs1234c, etc. If multi.list is TRUE, then the id list 
will be returned as a list, and any time an rs-id is entered without a letter suffix, all 
possible corresponding chip ids will be listed.}

\item{force.flat}{logical, if 'multi.list' is true, then some rs-ids might map to more than one
SNP. If force.flat is TRUE, then multiple SNP listings will be concatenated with a comma. If 
FALSE, then a list will be returned, with multiple entries where applicable.}
}
\value{
A character vector of SNP chip-ids, where the input was rs-ids, chip-ids or a mixture, 
any text other than this will result in NA values being returned in the character vector output.
Or, if multi-list is true, then returns a list instead, which takes more than 1 value where 
there are multiple chip-ids with the same rs-id; if there are no such rs-id duplicates the
result will still be a list. Currently rs-ids are always from build37.
}
\description{
Most SNPs will have an 'rs-id' from dbSNP/HapMap, and these are often the standard for reporting
or annotation lookup. These can differ from the IDs used on the chip. This functions looks at 
the current snp support (ChipInfo object) and looks up chip IDs based on rs-ids.
}
\examples{
rs.to.id(c("rs689","rs9467354","rs61733845"))  # middle one has no chip id
\donttest{
test.ids <- c("rs61733845","rs2227313","rs11577783","rs3748816",
                                    "rs12131065","rs3790567","rs2270614")
rs.to.id(test.ids, multi.list=TRUE) # list with duplicates
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{id.to.rs}}, \code{\link{GENE.to.ENS}}, \code{\link{ENS.to.GENE}}
}

