% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_nrst_haversine.R
\name{match_nrst_haversine}
\alias{match_nrst_haversine}
\title{Match coordinates to nearest coordinates}
\usage{
match_nrst_haversine(lat, lon, addresses_lat, addresses_lon,
  Index = seq_along(addresses_lat), cartesian_R = NULL,
  close_enough = 10, excl_self = FALSE, as.data.table = TRUE,
  .verify_box = TRUE)
}
\arguments{
\item{lat, lon}{Coordinates to be geocoded. Numeric vectors of equal length.}

\item{addresses_lat, addresses_lon}{Coordinates of known locations. Numeric vectors of equal length
(likely to be a different length than the length of \code{lat}, except when \code{excl_self = TRUE}).}

\item{Index}{A vector the same length as \code{lat} to encode the match between \code{lat,lon}
and \code{addresses_lat,addresses_lon}. The default is to use the integer position
of the nearest match to
\code{addresses_lat,addresses_lon}.}

\item{cartesian_R}{The maximum radius of any address from the points to be geocoded. Used
to accelerate the detection of minimum distances. Note, as the argument name suggests,
the distance is in cartesian coordinates, so a small number is likely.}

\item{close_enough}{The distance, in metres, below which a match will be considered to have occurred.
(The distance that is considered "close enough" to be a match.)

For example, \code{close_enough = 10} means the first location within ten metres will be matched,
even if a closer match occurs later.

May be provided as a string to emphasize the units, e.g. \code{close_enough = "0.25km"}.
Only \code{km} and \code{m} are permitted.}

\item{excl_self}{(bool, default: \code{FALSE}) For each \eqn{x_i} of the first coordinates,
exclude the \eqn{y_i}-th point when determining closest match. Useful to determine the
nearest neighbour within a set of coordinates, \emph{viz.}
\code{match_nrst_haversine(x, y, x, y, excl_self = TRUE)}.}

\item{as.data.table}{Return result as a \code{data.table}?
If \code{FALSE}, a list is returned. \code{TRUE} by default to
avoid dumping a huge list to the console.}

\item{.verify_box}{Check the initial guess against other points within the
box of radius \eqn{\ell^\infty}.}
}
\value{
A list (or \code{data.table} if \code{as.data.table = TRUE}) with two elements,
both the same length as \code{lat}, giving for point \code{lat,lon}:
\describe{
\item{\code{pos}}{the position (or corresponding value in \code{Table})
in \code{addresses_lat,addresses_lon} nearest to \code{lat, lon}.}
\item{\code{dist}}{the distance, in kilometres, between the two points.}
}
}
\description{
When geocoding coordinates to known addresses, an efficient way to
match the given coordinates with the known is necessary. This function provides this
efficiency by using \code{C++} and allowing approximate matching.
}
\examples{
lat2 <- runif(5, -38, -37.8)
lon2 <- rep(145, 5)

lat1 <- c(-37.875, -37.91)
lon1 <- c(144.96, 144.978)

match_nrst_haversine(lat1, lon1, lat2, lon2, 0L)
match_nrst_haversine(lat1, lon1, lat1, lon1, 11:12, excl_self = TRUE)

}
