% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{wrap}
\alias{wrap}
\alias{wrap<-}
\alias{set_wrap}
\alias{wrap.huxtable}
\alias{wrap<-.huxtable}
\title{Get or Set Cell Wrapping}
\usage{
wrap(ht)
wrap(ht) <- value
set_wrap(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix. If \code{TRUE}, long cell contents will be wrapped into multiple lines. Set to \code{NA} for the default. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{wrap}, the \code{wrap} attribute.
For \code{set_wrap}, the \code{ht} object.
}
\description{
Functions to get or set the cell wrapping property of huxtable table cells.
}
\examples{
ht <- huxtable(a = rep('Some long text', 2))
wrap(ht)[1,] <- TRUE
print_html(ht)
}
